# -*- coding: utf-8 -*-
from django.contrib.auth.decorators import login_required
from django.conf.urls import patterns, url

from django_intranet_stuff.views import user_or_group


urlpatterns = patterns('mlcore.mlapi.views',
    url(r'^lists/by_owner/(?P<login>\S+)/$', 'lists_by_owner'),
    url(r'^lists/external/$', 'external_lists'),
    url(r'^lists/non-project/$', 'non_project_lists'),
    url(r'^lists/info/$', 'lists_info'),
    url(r'^lists/$', 'list_names'),
    url(r'^lists/autocomplete/$', 'list_autocomplete'),
    url(r'^letter/(?P<letter>.).json$', 'lists_by_letter'),
    url(r'^lists/search.json$', 'lists_by_partname'),
    url(r'^user_or_group.json$', login_required(user_or_group), name='user_or_group'),
    url(r'^subscribers/info/$', 'subscribers_info', name='subscribers_info'),
)
