# encoding: utf-8
from django.http import HttpResponse
from django.db.models import Q
import json

from django_api_auth.decorators import passport_or_token_auth
from mlcore.ml.models import MailList
from mlcore.mlapi.forms import ListAutocompleteForm
from django.views.decorators.http import require_GET
from django.contrib.auth.decorators import login_required


@passport_or_token_auth
@require_GET
def list_autocomplete(request):

    form = ListAutocompleteForm(request.GET)

    if form.is_valid():

        q = form.cleaned_data['q']
        limit = form.cleaned_data['limit'] or 10

        qs = MailList.objects.filter(
                Q(name__startswith=q) | Q(email__startswith=q),
                is_deleted=False)

        if not form.cleaned_data['imap']:
            qs = qs.exclude(is_sub=0, is_imap=1)

        data = list(qs.values('name', 'email', 'is_open', 'info')[:limit])

        if form.cleaned_data['callback']:
            result = "%s(%s)" % (form.cleaned_data['callback'], json.dumps(data))
        else:
            result = json.dumps(data)

        return HttpResponse(result, mimetype="text/plain")
    else:
        return HttpResponse('', mimetype="text/plain", status=406)
