# encoding: utf-8

import logging
from django.http import HttpResponse
import json

from django_api_auth.decorators import passport_or_token_auth
from mlcore.ml.models import Subscribers
from mlcore.subscribe import subscription_type


logger = logging.getLogger(__name__)


@passport_or_token_auth
def subscribers_info(request):
    """
    Участники рассылок.
    Отдает список словарей (рассылка, пользователь, тип подписки)
    в формате JSON
    """
    def data_generator():
        subscription_types = {
#           imap   sub
            (True, True): subscription_type.BOTH,
            (True, False): subscription_type.IMAP,
            (False, True): subscription_type.INBOX,
            (False, False): subscription_type.NONE
        }

        subscribers = Subscribers.objects.filter(list__is_deleted=False).values_list(
                                                    'list__name', 'user__username', 'is_imap', 'is_sub')

        for maillist, user, is_imap, is_sub in subscribers:
            yield {
                'maillist': maillist,
                'user': user,
                'type': subscription_types[(is_imap, is_sub)]
            }

    return HttpResponse(json.dumps({'subscribers': list(data_generator())}), mimetype="text/plain")
