# encoding: utf-8

from django.contrib import admin
from .models import NwsmtpInfoCache
from mlcore.nwsmtp_connect.views import force_update_cache
from django.contrib import messages


class NwsmtpInfoCacheAdmin(admin.ModelAdmin):

    list_display = ("email", "modified_at", "body")
    ordering = ("modified_at",)
    search_fields = ("email", "body")
    actions = ('update_cache', )

    def update_cache(self, request, queryset):
        for data in queryset.select_related():
            force_update_cache(data.email)
        messages.info(request, u"Выбранные данные будут обновлены в кеше.")

    update_cache.short_description = u"Обновить данные в кеше"

admin.site.register(NwsmtpInfoCache, NwsmtpInfoCacheAdmin)