# encoding: utf-8
from mlcore.permissions.utils import get_permitted_staff

from .expander import Expander
from .utils import get_staff_by_email, get_maillist_by_email, is_email, get_passport_aliases


class EmailInfo(object):

    def __init__(self, email):
        self.email = email

    def maillist_dict(self, maillist):
        if maillist.is_deleted:
            return {}

        r = {
            'type': 'maillist',
            'is_internal': maillist.is_internal,
            'is_open': maillist.is_open,
            'subscribers': {'inbox': self._expand()},
        }
        if maillist.readonly:
            r['readonly'] = True
            r['who_can_write'] = get_passport_aliases(
                filter(None, set(get_permitted_staff(maillist, 'write')
                                 .filter(is_dismissed=False).values_list('work_email', flat=True))))

        return r

    def user_dict(self, user):
        return {
            'type': 'user',
            'login': user.login,
            'emails': self._expand()
        }

    def alias_dict_as_list(self, maillist=None):
        r = {
            'type': 'maillist',
            'is_internal': False,
            'is_open': True,
        }
        if maillist and maillist.readonly:
            r['is_internal'] = maillist.is_internal
            r['is_open'] = maillist.is_open
            r['readonly'] = True
            r['who_can_write'] = get_passport_aliases(
                filter(None, set(get_permitted_staff(maillist, 'write')
                                 .filter(is_dismissed=False).values_list('work_email', flat=True))))
        r['subscribers'] = {'inbox': self._expand()}
        return r

    def _expand(self):
        return list(set(Expander.expand(self.email)))

    def _get_info(self):
        if not is_email(self.email):
            return None

        maillist = get_maillist_by_email(self.email)
        if maillist:
            return self.maillist_dict(maillist)

        staff = get_staff_by_email(self.email, strict=False)
        if staff:
            return self.user_dict(staff)
        return None

    def as_dict(self):
        return self._get_info()
