# -*- coding: utf-8 -*-
import json
from django.db import models

class NwsmtpInfoCache(models.Model):
    """
    NwsmtpInfoCache cache model.

    Кэш для готовых ответов ручки delivery/info
    Проблема описана в таске ML-1350
    """

    class Meta:
        verbose_name = u'Кэш для nwsmtp'
        ordering = ('email',)

    email = models.EmailField(max_length=255, primary_key=True)
    modified_at = models.DateTimeField(auto_now=True)
    body = models.TextField(blank=True, null=True)
    headers = models.TextField(blank=True, null=True)
    version = models.CharField(max_length=16, blank=True, null=True)

    def load_headers(self):
        if self.headers:
            return json.loads(self.headers)
        else:
            return {}

    def save_headers(self, headers):
        if headers:
            self.headers = json.dumps(headers)
        else:
            self.headers = None

    def save_body(self, body):
        if body:
            self.body = json.dumps(body)
        else:
            self.body = None
