from django.contrib import admin
from django.contrib.auth.models import User

from django_intranet_stuff.models import Group
from mlcore.ml.models import MailList
from mlcore.permissions.models import Type, ListPermission, GroupPermission, SubscriptionRequest

class GroupPermissionAdmin(admin.ModelAdmin):

    list_display = ('group', 'type', 'list')
    list_filter = ('type',)

    def formfield_for_foreignkey(self, db_field, request, **kwargs):
        if (db_field.name == 'list'):
            kwargs['queryset'] = MailList.objects.order_by('name')
        elif db_field.name == 'group':
            kwargs['queryset'] = Group.objects.order_by('name')

        return super(GroupPermissionAdmin, self)\
            .formfield_for_foreignkey(db_field, request, **kwargs)


class ListPermissionAdmin(admin.ModelAdmin):

    list_display = ('user', 'type', 'list', 'approved')
    list_filter = ('approved', 'type')
    date_hierarchy = 'modified'
    search_fields = ('user__username',)

    def formfield_for_foreignkey(self, db_field, request, **kwargs):
        if (db_field.name == 'list'):
            kwargs['queryset'] = MailList.objects.order_by('name')
        elif db_field.name == 'user':
            kwargs['queryset'] = User.objects.order_by('username')
        return super(ListPermissionAdmin, self)\
                .formfield_for_foreignkey(db_field, request, **kwargs)


class SubscriptionRequestAdmin(admin.ModelAdmin):

    search_fields = ('permission__user__username', 'permission__list__name')
    list_display = ('permission', 'access_reason', 'type')
    list_filter = ('type',)
    list_per_page = 20


admin.site.register(Type)
admin.site.register(ListPermission, ListPermissionAdmin)
admin.site.register(SubscriptionRequest, SubscriptionRequestAdmin)
admin.site.register(GroupPermission, GroupPermissionAdmin)

