# -*- coding: utf-8 -*-
from django.contrib.auth.models import User
from django.db import transaction
from mlcore.permissions.models import ListPermission


def is_user_owner(maillist, user):
    if user.is_authenticated():
        return bool(maillist.owner_set.filter(user=user).exists()) or user.is_staff
    return False


@transaction.atomic
def grant_user_permissions(maillist, usernames, messager=None):
    """
    Create permissons and approve it
    """
    users = User.objects.filter(username__in=usernames).only('id', 'email')
    for user in users:
        ListPermission.objects.grant_permission(maillist=maillist, user=user)
    return True
