# -*- coding: utf-8 -*-

from optparse import make_option

from django_intranet_stuff.commands import UpdateCommand
from mlcore.permissions.center_group_synchro import import_group_membership_log

class Command(UpdateCommand):

    help = 'Synchronize group membership log with center'

    option_list = UpdateCommand.option_list
    if '--all' not in [opt.get_opt_string() for opt in UpdateCommand.option_list]:
        option_list += make_option('-a', '--all', action='store_true', dest='all_',
            help='Parse full log history; Ignore last update timestamp'),

    last_update_type = 'membership_log'

    def handle_update(self, *args, **options):
        last_update = None if options.get('all_', False) else options['last_update_at']
        new_last_update = import_group_membership_log(last_update)
        return new_last_update, None
