# -*- coding: utf-8 -*-

# Created by IntelliJ IDEA.
# @author jay
# @date Jun 24, 2010

from django.core.management.base import NoArgsCommand
from mlcore.ml.models import Subscribers
from mlcore.permissions.models import ListPermission

class Command(NoArgsCommand):
    help = "Displays users who are subscribed but do not have permissions"

    def handle_noargs(self, **options):

        for subs in Subscribers.objects.select_related("user", "list").filter(list__is_open=False, user__isnull=False):
            try:
                p = ListPermission.objects.get(user=subs.user, list=subs.list, type__name="read")
                if p.approved:
                    continue
            except ListPermission.DoesNotExist:
                print "%s on [%s]" % (subs.user.username, subs.list.name)
