# -*- coding: utf-8 -*-

# Created by IntelliJ IDEA.
# @author jay
# @date Jun 1, 2010

from django.core.management.base import NoArgsCommand
from mlcore.permissions.notifications import PermissionReminder
from mlcore.permissions.models import ListPermission

class Command(NoArgsCommand):
    help = "Sends pending permission requests notification"

    def handle_noargs(self, **options):
        requests = ListPermission.objects.old_requests().select_related("list", "list__owner_set", "user")\
                    .exclude(list__is_deleted=True)
        owner2requests = {}
        for request in requests:
            if request.list.owner_set.count() == 0:
                if not "default" in owner2requests:
                    owner2requests["default"] = []
                owner2requests["default"].append(request)
            else:
                for owner in request.list.owner_set.all():
                    if not owner in owner2requests:
                        owner2requests[owner] = []
                    owner2requests[owner].append(request)

        for owner in owner2requests:
            requests = owner2requests[owner]
            if owner == "default":
                owner = None
            notification = PermissionReminder(requests, owner)
            notification.send()
