# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Adding field 'SubscriptionRequest.access_reason'
        db.add_column('permissions_subscriptionrequest', 'access_reason',
                      self.gf('django.db.models.fields.CharField')(default=None, max_length=200, null=True, blank=True),
                      keep_default=False)


    def backwards(self, orm):
        # Deleting field 'SubscriptionRequest.access_reason'
        db.delete_column('permissions_subscriptionrequest', 'access_reason')


    models = {
        'auth.group': {
            'Meta': {'object_name': 'Group'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        'auth.permission': {
            'Meta': {'ordering': "('content_type__app_label', 'content_type__model', 'codename')", 'unique_together': "(('content_type', 'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['contenttypes.ContentType']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        },
        'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'django_intranet_stuff.city': {
            'Meta': {'object_name': 'City', 'db_table': "'intranet_city'"},
            'color': ('django.db.models.fields.CharField', [], {'default': "'000000'", 'max_length': '6'}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'intranet_status': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100', 'blank': 'True'}),
            'native_lang': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '2', 'blank': 'True'}),
            'position': ('django.db.models.fields.IntegerField', [], {'default': '0'})
        },
        'django_intranet_stuff.department': {
            'Meta': {'object_name': 'Department', 'db_table': "'intranet_department'"},
            'bg_color': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '20'}),
            'code': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '20'}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {}),
            'description': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '4096'}),
            'description_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '4096'}),
            'en_name': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'fg_color': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '20'}),
            'from_staff_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'intranet_status': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'jira_project': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'level': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'lft': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'maillists': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '4096'}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'name_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'native_lang': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '2', 'blank': 'True'}),
            'parent': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'children'", 'null': 'True', 'to': "orm['django_intranet_stuff.Department']"}),
            'position': ('django.db.models.fields.IntegerField', [], {'default': '0'}),
            'rght': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'short_name': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'short_name_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'tree_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'url': ('django.db.models.fields.CharField', [], {'default': "''", 'unique': 'True', 'max_length': '255'}),
            'wiki_page': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'})
        },
        'django_intranet_stuff.group': {
            'Meta': {'unique_together': "[('parent', 'role_scope_id')]", 'object_name': 'Group', 'db_table': "'intranet_group'"},
            'code': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '127', 'db_index': 'True'}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {}),
            'department': ('django.db.models.fields.related.OneToOneField', [], {'to': "orm['django_intranet_stuff.Department']", 'unique': 'True', 'null': 'True', 'blank': 'True'}),
            'description': ('django.db.models.fields.TextField', [], {}),
            'externals_count': ('django.db.models.fields.PositiveIntegerField', [], {'default': '0'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'intranet_status': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'level': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'lft': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'members': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'in_groups'", 'symmetrical': 'False', 'through': "orm['django_intranet_stuff.GroupMembership']", 'to': "orm['django_intranet_stuff.Staff']"}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '127', 'db_index': 'True'}),
            'native_lang': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '2', 'blank': 'True'}),
            'parent': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'children'", 'null': 'True', 'to': "orm['django_intranet_stuff.Group']"}),
            'position': ('django.db.models.fields.IntegerField', [], {'default': '0', 'null': 'True'}),
            'rght': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'role_scope_id': ('django.db.models.fields.CharField', [], {'max_length': '127', 'null': 'True', 'blank': 'True'}),
            'service_id': ('django.db.models.fields.PositiveIntegerField', [], {'null': 'True', 'blank': 'True'}),
            'tree_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'type': ('django.db.models.fields.PositiveSmallIntegerField', [], {'default': '0'}),
            'url': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '255', 'db_index': 'True'})
        },
        'django_intranet_stuff.groupmembership': {
            'Meta': {'unique_together': "(('staff', 'group'),)", 'object_name': 'GroupMembership', 'db_table': "'intranet_groupmembership'"},
            'group': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.Group']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'joined_at': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'staff': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.Staff']"})
        },
        'django_intranet_stuff.office': {
            'Meta': {'object_name': 'Office', 'db_table': "'intranet_office'"},
            'address1': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'address1_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'address2': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'address2_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'city': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.City']", 'null': 'True', 'blank': 'True'}),
            'code': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '20'}),
            'color': ('django.db.models.fields.CharField', [], {'max_length': '10'}),
            'coord_x': ('django.db.models.fields.FloatField', [], {'null': 'True'}),
            'coord_y': ('django.db.models.fields.FloatField', [], {'null': 'True'}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {}),
            'fax': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50'}),
            'from_staff_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'have_map': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'intranet_status': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'name_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'native_lang': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '2', 'blank': 'True'}),
            'phone': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50'}),
            'position': ('django.db.models.fields.IntegerField', [], {'default': '0'}),
            'tz': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '20'}),
            'zoom': ('django.db.models.fields.PositiveSmallIntegerField', [], {'default': '0'})
        },
        'django_intranet_stuff.staff': {
            'Meta': {'object_name': 'Staff', 'db_table': "'intranet_staff'"},
            'affiliation': ('django.db.models.fields.CharField', [], {'max_length': '32', 'db_index': 'True'}),
            'car': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100'}),
            'car_num': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100'}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {}),
            'department': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.Department']", 'null': 'True'}),
            'domain': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '1'}),
            'en_name': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'first_name': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50', 'db_index': 'True'}),
            'first_name_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50', 'db_index': 'True'}),
            'from_staff_id': ('django.db.models.fields.PositiveIntegerField', [], {'default': '0', 'db_index': 'True'}),
            'gender': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '1'}),
            'guid': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '47', 'null': 'True'}),
            'hide_middle_name': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'intranet_status': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'is_big_boss': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_dismissed': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_homeworker': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_robot': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'join_at': ('django.db.models.fields.DateField', [], {'null': 'True'}),
            'lang_content': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'lang_ui': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '2'}),
            'last_name': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100', 'db_index': 'True'}),
            'last_name_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100', 'db_index': 'True'}),
            'login': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50', 'db_index': 'True'}),
            'login_ld': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '50', 'db_index': 'True'}),
            'login_mail': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50', 'db_index': 'True'}),
            'middle_name': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50'}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {}),
            'native_lang': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '2', 'blank': 'True'}),
            'normal_login': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50', 'db_index': 'True'}),
            'office': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.Office']", 'null': 'True'}),
            'position': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '150'}),
            'position_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '150'}),
            'tz': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '30'}),
            'user': ('django.db.models.fields.related.OneToOneField', [], {'to': "orm['auth.User']", 'unique': 'True', 'null': 'True'}),
            'work_email': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100', 'db_index': 'True'})
        },
        'ml.maillist': {
            'Meta': {'ordering': "('name',)", 'unique_together': "[('alias', 'parent')]", 'object_name': 'MailList', 'db_table': "'wakka_maillists'"},
            'alias': ('django.db.models.fields.CharField', [], {'max_length': '255', 'db_index': 'True'}),
            'before_clean': ('django.db.models.fields.IntegerField', [], {'default': 'None', 'null': 'True', 'blank': 'True'}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'created_dt': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'db_index': 'True'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '255', 'null': 'True', 'db_index': 'True'}),
            'external_staff_can_read': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'fid': ('django.db.models.fields.BigIntegerField', [], {'null': 'True', 'blank': 'True'}),
            'fsuid': ('django.db.models.fields.BigIntegerField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'imap_users': ('django.db.models.fields.PositiveIntegerField', [], {'default': '0'}),
            'info': ('django.db.models.fields.TextField', [], {}),
            'info_en': ('django.db.models.fields.TextField', [], {'default': "''"}),
            'info_modified': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_archive': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_deleted': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_hidden': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_imap': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_internal': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_mandatory': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_manual': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_open': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_relevance_tracked': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_sms': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_sub': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_virtual': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'letter': ('django.db.models.fields.CharField', [], {'max_length': '1', 'db_index': 'True'}),
            'max_length': ('django.db.models.fields.PositiveIntegerField', [], {}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '255', 'db_index': 'True'}),
            'parent': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'children'", 'null': 'True', 'to': "orm['ml.MailList']"}),
            'preferred_language': ('django.db.models.fields.CharField', [], {'default': "'ru'", 'max_length': '6', 'db_index': 'True'}),
            'readonly': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'relevance': ('django.db.models.fields.FloatField', [], {'default': '0.0', 'db_index': 'True'}),
            'sub_users': ('django.db.models.fields.PositiveIntegerField', [], {'default': '0'})
        },
        'permissions.grouppermission': {
            'Meta': {'unique_together': "(('group', 'list', 'type'),)", 'object_name': 'GroupPermission'},
            'group': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'permissions'", 'to': "orm['django_intranet_stuff.Group']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'list': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['ml.MailList']"}),
            'type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['permissions.Type']"})
        },
        'permissions.listpermission': {
            'Meta': {'unique_together': "(('user', 'list', 'type'),)", 'object_name': 'ListPermission'},
            'approved': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'db_index': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'list': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['ml.MailList']"}),
            'modified': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['permissions.Type']"}),
            'user': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'permissions'", 'to': "orm['auth.User']"})
        },
        'permissions.subscriptionrequest': {
            'Meta': {'object_name': 'SubscriptionRequest'},
            'access_reason': ('django.db.models.fields.CharField', [], {'default': 'None', 'max_length': '200', 'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'meddler': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'subscriptionrequest_via_meddler_set'", 'null': 'True', 'to': "orm['auth.User']"}),
            'permission': ('django.db.models.fields.related.OneToOneField', [], {'to': "orm['permissions.ListPermission']", 'unique': 'True'}),
            'type': ('django.db.models.fields.CharField', [], {'max_length': '10', 'null': 'True'})
        },
        'permissions.type': {
            'Meta': {'object_name': 'Type'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'null': 'True'})
        }
    }

    complete_apps = ['permissions']