#-*- coding: utf-8 -*-

from django.db import models
from django.contrib.auth.models import User

from django_intranet_stuff.models import Group

from mlcore.utils.cache import GetCachingManager
from mlcore.permissions.managers import ListPermissionManager, GroupPermissionManager


class Type(models.Model):

    name = models.CharField(max_length=30, null=True)

    objects = GetCachingManager(300)

    def __unicode__(self):
        return self.name


class ListPermission(models.Model):

    class Meta:
        unique_together = (('user', 'list', 'type'),)

    user = models.ForeignKey(User, related_name="permissions")
    list = models.ForeignKey('ml.MailList')
    type = models.ForeignKey(Type)
    approved = models.BooleanField(default=False, db_index=True)
    modified = models.DateTimeField(auto_now=True)

    def __unicode__(self):
        s = u"%s can %s %s" % (self.user.username, self.type, self.list.name)
        if not self.approved:
            s = u"? " + s
        return s

    def natural_key(self):
        return (self.user.username, self.list.name, self.type_id)

    objects = ListPermissionManager()


class SubscriptionRequest(models.Model):
    permission = models.OneToOneField(ListPermission)
    type = models.CharField(max_length=10, null=True)
    meddler = models.ForeignKey(User, null=True, blank=True,
                                related_name='subscriptionrequest_via_meddler_set')
    access_reason = models.CharField(null=True, blank=True, max_length=200, default=None)

    def natural_key(self):
        return (self.type, self.meddler.username, self.access_reason)


class GroupPermission(models.Model):

    class Meta:
        unique_together = (('group', 'list', 'type'),)

    group = models.ForeignKey(Group, related_name="permissions")
    list = models.ForeignKey('ml.MailList')
    type = models.ForeignKey(Type)

    objects = GroupPermissionManager()

    def natural_key(self):
        return (self.group.url, self.list.name, self.type_id)

    def __unicode__(self):
        return u"%s can %s %s" % (self.group, self.type, self.list.name)
