# -*- coding: utf-8 -*-
from mlcore.permissions.utils import get_permitted_folders, get_group_permissons


def get_group_list_permissions(user_obj):
    if user_obj.is_anonymous():
        return set()

    if not hasattr(user_obj, '_group_perm_cache'):
        user_obj._perm_cache = set(
            '%s.%s' % (listname, u'read')
                for fid, listname
                in get_group_permissons(user_obj).values('fid', 'name'))
    return user_obj._perm_cache


def get_all_list_permissions(user_obj):
    if user_obj.is_anonymous():
        return set()

    if not hasattr(user_obj, '_perm_cache'):
        user_obj._perm_cache = set(
            '%s.%s' % (listname, u'read')
                for fid, listname
                in get_permitted_folders(user_obj).values_list('fid', 'name'))
    return user_obj._perm_cache
