# -*- coding: utf-8 -*-

from django.dispatch import Signal
from django.conf import settings

permission_approved = Signal()
permission_denied = Signal()
permissions_granted = Signal(
        providing_args=['by_owner', 'list', 'granted_users'])
group_permission_granted = Signal(
        providing_args=['group_id', 'list', 'by_owner'])
group_permission_revoked = Signal(
        providing_args=['group_id', 'list_id', 'by_owner', 'group_deleted'])
group_membership_changed = Signal(
        providing_args=['staff_id', 'group_id', 'action', 'modified_at'])
user_access_revoked = Signal(
        providing_args=['user', 'list', 'extra_context'])

from mlcore.permissions.models import SubscriptionRequest
from mlcore.permissions.notifications import PermissionApproved,\
         PermissionDenied, GrantedAccess

def permission_approved_notify(sender, **kwargs):
    list = None
    for perm in sender:
        list = perm.list
        break
    context = {"list": list}
    try:
        context["type"] = perm.subscriptionrequest.type
    except SubscriptionRequest.DoesNotExist:
        pass
    n = PermissionApproved(context)
    for perm in sender:
        n.send([perm.user.email], sender=settings.SERVICE_EMAIL)


def permission_denied_notify(sender, **kwargs):
    for perm in sender:
        list = perm.list
        context = {"list": list}
        try:
            context["type"] = perm.subscriptionrequest.type
        except SubscriptionRequest.DoesNotExist:
            pass
        n = PermissionDenied(context)
        n.send([perm.user.email], sender=settings.SERVICE_EMAIL)


def permissions_granted_notify(sender, **kwargs):
    users = kwargs.pop('granted_users')
    notification = GrantedAccess(kwargs)
    notification.send([u.email for u in users], sender=settings.SERVICE_EMAIL)

permission_approved.connect(permission_approved_notify)
permission_denied.connect(permission_denied_notify)
permissions_granted.connect(permissions_granted_notify)
