# encoding: utf-8
from django.dispatch import receiver
from django.db import models
import datetime
import logging

from django.core.exceptions import ObjectDoesNotExist
from django_intranet_stuff.models import Group, GroupMembership, Log

try:
    from django_intranet_stuff.models import ACTION_SAVE, ACTION_DELETE
except ImportError:
    from django_intranet_stuff.models.log import ACTION_SAVE, ACTION_DELETE

from django.db.utils import IntegrityError

@receiver(models.signals.post_save, sender=Group)
def log_group_save(sender, created, instance, **kwargs):
    if instance.intranet_status != 0: return
    try:
        l = Log.objects.get(primary_key=instance.pk,
                model_name='Group',
                action=ACTION_SAVE)
    except Log.DoesNotExist:
        l = Log(primary_key=instance.pk,
                model_name='Group',
                action=ACTION_SAVE)

    l.data = '"intranet_status": 0'
    l.modified_at=datetime.datetime.now()
    l.save()


@receiver(models.signals.post_delete, sender=GroupMembership)
def log_membership_delete(sender, instance, **kwargs):
    try:
        l = Log.objects.get(primary_key=instance.pk, model_name='GroupMembership', action=ACTION_DELETE)
    except Log.DoesNotExist:
        l = Log(primary_key=instance.pk, model_name='GroupMembership', action=ACTION_DELETE)

    l.data = '[{"pk": %d, "model": "django_intranet_stuff.groupmembership", ' \
             '"fields": {"joined_at": "%s", "group": %d, "staff": %d}}]' % \
             (instance.pk, instance.joined_at, instance.group.pk, instance.staff.pk)
    # если instance.staff не находится - надо удалить устаревшего юзера из auth_user
    l.modified_at = datetime.datetime.now()
    l.save()
