from models import *
from django.contrib import admin

class FilterInline(admin.TabularInline):
    model = Filter
    extra = 0
    ordering = ['id']


class SMSMailListAdmin(admin.ModelAdmin):
    list_display = ['mail_list', 'comment', 'last_update']
    fields = ['mail_list', 'comment', 'last_update']
    readonly_fields = ['last_update']
    order_by = ['mail_list__name']
    inlines = [FilterInline]
    change_form_template = 'sms_filter/change_filter.html'


admin.site.register(SMSMailList, SMSMailListAdmin)
