# -*- coding: utf-8 -*-
from django.db import models


class SMSMailList(models.Model):
    mail_list = models.ForeignKey(
        'ml.MailList',
        limit_choices_to={'is_sms': True},
        help_text=u'Must support SMS')
    comment = models.TextField(
        blank=True)
    last_update = models.DateTimeField(
        blank=True,
        null=True,
        verbose_name=u'Last synchronization')

    class Meta:
        verbose_name = u'SMS Mail List'
        verbose_name_plural = u'SMS Mail Lists'


class Filter(models.Model):
    sms_mail_list = models.ForeignKey('SMSMailList', related_name='filters')
    TYPE_CHOICE = (
        ('car', u'Have car'),
        ('department', u'Departments'),
        ('office', u'Office'),
        #('join_at', u'Joined at'),
        ('position', u'Position'),
    )
    type = models.CharField(max_length=10, choices=TYPE_CHOICE)
    condition = models.CharField(max_length=255)

    class Meta:
        verbose_name = u'Filter'
        verbose_name_plural = u'Filters'
