# Create your views here.

from django.http import HttpResponse
from django.shortcuts import render_to_response, get_object_or_404
from django.contrib.auth.decorators import user_passes_test

from django_intranet_stuff.models import Department, Office

from models import SMSMailList
from filter import update_mail_list, get_sms_mail_list_logins, SMSFilterError

is_staff = user_passes_test(lambda u: u.is_staff)

@is_staff
def preview(request, sms_mail_list_id):
    sms_mail_list = get_object_or_404(SMSMailList, id=sms_mail_list_id)
    try:
        logins = get_sms_mail_list_logins(sms_mail_list)
        if logins:
            logins.sort()
            count = len(logins)
            return HttpResponse('<b>%s user%s:</b> %s' % (
                count,
                's' if count > 1 else '',
                ', '.join(logins)
            ))
        else:
            return HttpResponse('<b>Empty list :(</b>')
    except SMSFilterError, ex:
        return HttpResponse('<b>Error occured: %s</b>' % ex)

@is_staff
def list_offices(request):
    return render_to_response('sms_filter/offices_list.html', {
        'offices': Office.objects.all().order_by('id'),
    })

@is_staff
def list_departments(request):
    return render_to_response('sms_filter/departments_tree.html', {
        'departments': Department.objects.select_related().all(),
     })

@is_staff
def update(request, sms_mail_list_id):
    sms_mail_list = get_object_or_404(SMSMailList, id=sms_mail_list_id)
    success, message = update_mail_list(sms_mail_list.mail_list)
    if success:
        response = 'Successfully updated'
    else:
        response = 'An error occured: %s' % message
    return HttpResponse(response, mimetype='text/plain')
