# -*- coding: utf-8 -*-

from django.db import models

class SubscribeActivityManager(models.Manager):

    def stats(self, begin=None, end=None):
        from django.db import connection
        cursor = connection.cursor()
        cursor.execute("""
            SELECT COUNT(*) AS `count`, DATE(`datetime`) AS `date`, `sub_action`, `where`
            FROM
                `wakka_subscribeactivity`
            WHERE
                `datetime`
            BETWEEN %s AND %s
            GROUP BY
                `date`, `sub_action`, `where`
        """, [begin, end])
        rows = []
        if cursor.rowcount < 1:
            return rows

        cur_date = None
        item = None
        for i in xrange(cursor.rowcount):
            count, date, sub_action, where = cursor.fetchone()

            # begin new item for new date
            if not cur_date or cur_date != date:
                cur_date = date
                if item:
                    # add item to rows
                    rows.append(item)
                item = dict(date=cur_date, service_subscribes=0, service_unsubscribes=0,
                    client_subscribes=0, client_unsubscribes=0)

            # add values to item
            if sub_action == 0 and where == 1: # where=1 - Client
                key = 'client_unsubscribes'
            elif sub_action == 1 and where == 1: # where=1 - Client
                key = 'client_subscribes'
            elif sub_action == 1 and where == 2: # where=2 - Service
                key = 'service_subscribes'
            else:
                key = 'service_unsubscribes'
            item[key] += count

        # add last item to rows
        rows.append(item)

        return rows
