from operator import attrgetter

def get_activity_log(user, offset=0, limit=10):
    if limit is not None:
        return get_activity_log_slice(user, offset=offset, limit=limit)

    subscribe_log = user.subscribeoperationlog_set\
                    .order_by('-datetime')\
                    .filter(operation_result_code=1)
    access_log = user.access_log.order_by('-datetime')

    return sorted(list(subscribe_log) + list(access_log),
                key=attrgetter('datetime'), reverse=True)


def get_activity_log_slice(user, offset=0, limit=10):
    right_edge = offset + limit
    subscribe_log = user.subscribeoperationlog_set\
                    .order_by('-datetime')\
                    .filter(operation_result_code=1)[:right_edge]
    access_log = user.access_log.order_by('-datetime')[:right_edge]

    return sorted(list(subscribe_log) + list(access_log),
                key=attrgetter('datetime'), reverse=True)[offset:right_edge]
