class BaseMaillistBackendInterface(object):

    BACKEND_METHODS = (
            'subscribe_imap',
            'unsubscribe_imap',
            'subscribe_inbox',
            'unsubscribe_inbox',
            'subscribe_email',
            'unsubscribe_email',
            'create_maillist',
            'get_maillists',
        )

    type = None
    model_class = None
    is_master = False

    def subscribe(self, backend_context, s_type, **op_context):
        method_name = '_'.join(['subscribe', s_type.lower()])
        return getattr(self, method_name)(backend_context, **op_context)

    def unsubscribe(self, backend_context, s_type, **op_context):
        method_name = '_'.join(['unsubscribe', s_type.lower()])
        return getattr(self, method_name)(backend_context, **op_context)

    def subscribe_imap(self, backend_context, user):
        raise NotImplementedError

    def unsubscribe_imap(self, backend_context, user):
        raise NotImplementedError

    def subscribe_inbox(self, backend_context, user):
        raise NotImplementedError

    def unsubscribe_inbox(self, backend_context, user):
        raise NotImplementedError

    def subscribe_email(self, backend_context, email):
        raise NotImplementedError

    def unsubscribe_email(self, backend_context, email):
        raise NotImplementedError

    def create_maillist(self, **options):
        raise NotImplementedError

    def get_maillists(self, s_type):
        raise NotImplementedError

    for method_name in BACKEND_METHODS:
        method = locals().get(method_name)
        if method:
            method.not_implemented = True
