# -*- coding: utf-8 -*-
from mlcore.subscribe.backends.base import BaseMaillistBackendInterface


def operation_context_to_backend_method(operation_id, operation_args):
    '''
    >>> operation_context_to_backend_method("+imap", {})
    'subscribe_imap'
    >>> operation_context_to_backend_method("-email", {})
    'unsubscribe_email'
    >>> operation_context_to_backend_method("create_maillist", {})
    'create_maillist'
    >>> operation_context_to_backend_method("make_me_happy", {})
    Traceback (most recent call last):
    ...
    ValueError: Unknown operation id or method name: make_me_happy
    '''

    if operation_id[0] in ("+", "-"):
        prefix, s_type = _parse_direction_based_opid(operation_id)
        return "%s_%s" % (prefix, s_type)
    else:
        if operation_id in BaseMaillistBackendInterface.BACKEND_METHODS:
            return operation_id
        else:
            raise ValueError("Unknown operation id or method name: %s"
                    % operation_id)


def _parse_direction_based_opid(operation_id):
    '''
    >>> _parse_direction_based_opid("+imap")
    ('subscribe', 'imap')
    >>> _parse_direction_based_opid("-inbox")
    ('unsubscribe', 'inbox')
    '''
    direction, s_type = operation_id[0], operation_id[1:]
    assert direction in ("+", "-")

    if direction == '+':
        prefix = "subscribe"
    elif direction == '-':
        prefix = "unsubscribe"
    else:
        raise ValueError("Expected + or - as first symbol in operation_id (like +imap)")

    return prefix, s_type
