import logging

from django.core.management.base import BaseCommand

from mlcore.subscribe.backends.yandex_team.models import YandexTeamBackendContext
from mlcore.utils.getters import get_suid

logger = logging.getLogger(__name__)


class Command(BaseCommand):
    help = "Subscribe all unsubscribed staff (except yandex_money) to office announces, if possible"

    def handle(self, *args, **options):
        for ctx in YandexTeamBackendContext.objects\
                .filter(fsuid__isnull=True).select_related('maillist'):
            ctx.maillist.fsuid = ctx.fsuid = fsuid = get_suid(ctx.passport_name)
            if fsuid is not None:
                ctx.maillist.save()
                ctx.save()
            else:
                logger.warning('Can\'t get fsuid for maillist (passport desync?): %s, id %s',
                        ctx.passport_name, ctx.maillist.id)
