import logging

from django.core.management.base import BaseCommand

from mlcore.subscribe.backends.yandex_team.models import YandexTeamBackendContext
from mlcore.utils import blackbox_util

logger = logging.getLogger(__name__)


class Command(BaseCommand):
    help = "Sync uid for mail lists"

    def handle(self, *args, **options):
        for ctx in YandexTeamBackendContext.objects\
                .filter(uid__isnull=True).select_related('maillist'):
            ctx.uid = uid = blackbox_util.get_uid(ctx.passport_name)
            try:
                if uid:
                    ctx.save()
                else:
                    logger.warning('Can\'t get uid for maillist (passport desync?): %s, id %s',
                            ctx.passport_name, ctx.maillist.id)
            except:
                logger.exception('Can\'t get uid for maillist (passport desync?): %s, id %s',
                                 ctx.passport_name, ctx.maillist.id)
