# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        
        # Adding model 'YandexTeamBackendContext'
        db.create_table('yandex_team_context', (
            ('backendcontext_ptr', self.gf('django.db.models.fields.related.OneToOneField')(to=orm['ml.BackendContext'], unique=True, primary_key=True)),
            ('passport_name', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, db_index=True)),
            ('fsuid', self.gf('django.db.models.fields.BigIntegerField')(null=True, blank=True)),
            ('fid', self.gf('django.db.models.fields.BigIntegerField')(null=True, blank=True)),
        ))
        db.send_create_signal('yandex_team', ['YandexTeamBackendContext'])

    def backwards(self, orm):
        
        # Deleting model 'YandexTeamBackendContext'
        db.delete_table('yandex_team_context')

    models = {
        'ml.backendcontext': {
            'Meta': {'unique_together': "[('backend_type', 'maillist')]", 'object_name': 'BackendContext'},
            'backend_type': ('django.db.models.fields.CharField', [], {'max_length': '32', 'null': 'True', 'db_index': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_imap': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_sub': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'maillist': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'backends'", 'to': "orm['ml.MailList']"})
        },
        'ml.maillist': {
            'Meta': {'ordering': "('name',)", 'object_name': 'MailList', 'db_table': "'wakka_maillists'"},
            'created_at': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'created_dt': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'db_index': 'True'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '255', 'null': 'True'}),
            'fid': ('django.db.models.fields.BigIntegerField', [], {'null': 'True', 'blank': 'True'}),
            'fsuid': ('django.db.models.fields.BigIntegerField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'imap_users': ('django.db.models.fields.PositiveIntegerField', [], {'default': '0'}),
            'info': ('django.db.models.fields.TextField', [], {'null': 'True'}),
            'info_modified': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_deleted': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_hidden': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_imap': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_internal': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_mandatory': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_manual': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_open': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_sms': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_sub': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'letter': ('django.db.models.fields.CharField', [], {'max_length': '1', 'null': 'True', 'db_index': 'True'}),
            'max_length': ('django.db.models.fields.PositiveIntegerField', [], {}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255', 'unique': 'True', 'null': 'True', 'db_index': 'True'}),
            'sub_users': ('django.db.models.fields.PositiveIntegerField', [], {'default': '0'})
        },
        'yandex_team.yandexteambackendcontext': {
            'Meta': {'object_name': 'YandexTeamBackendContext', 'db_table': "'yandex_team_context'", '_ormbases': ['ml.BackendContext']},
            'backendcontext_ptr': ('django.db.models.fields.related.OneToOneField', [], {'to': "orm['ml.BackendContext']", 'unique': 'True', 'primary_key': 'True'}),
            'fid': ('django.db.models.fields.BigIntegerField', [], {'null': 'True', 'blank': 'True'}),
            'fsuid': ('django.db.models.fields.BigIntegerField', [], {'null': 'True', 'blank': 'True'}),
            'passport_name': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'db_index': 'True'})
        }
    }

    complete_apps = ['yandex_team']
