from django.db import models

from mlcore.ml.models import BackendContext


class YandexTeamBackendContext(BackendContext):

    # single name for both types
    passport_name = models.CharField(max_length=255, db_index=True)
    # passport service uid for this 'user'
    fsuid = models.BigIntegerField(blank=True, null=True)
    fid = models.BigIntegerField(blank=True, null=True)
    uid = models.BigIntegerField(blank=True, null=True)

    class Meta:
        db_table = 'yandex_team_context'

    def save(self, *args, **kwargs):
        self.backend_type = 'yandex_team'
        super(YandexTeamBackendContext, self).save(*args, **kwargs)

    def as_dict(self):
        base_dict = super(YandexTeamBackendContext, self).as_dict()
        base_dict['passport_name'] = self.passport_name
        base_dict['fid'] = self.fid
        base_dict['fsuid'] = self.fsuid
        return base_dict
