# -*- coding: utf-8 -*-

import logging
from xml.dom import minidom
from xml.parsers.expat import ExpatError
from urllib import urlopen

from django.conf import settings
from .exceptions import PassportException

logger = logging.getLogger(__name__)


PASSPORT_REGISTER_URL = "%s/passport?mode=admsimplereg&login=%%s&maillist=1&external_email=%%s"\
        % (settings.PASSPORT_URL)


def create_passport_maillist(maillist_name, default_email):
    if not maillist_name:
        return False
    logger.info("Creating ML user in passport: %s, default_email: %s",  maillist_name, default_email)
    xml = urlopen(PASSPORT_REGISTER_URL % (maillist_name, default_email)).read()

    try:
        dom = minidom.parseString(xml)
    except ExpatError, e:
        logger.error("Expat error on imap user creation: %s", e)
        raise PassportException("Invalid xml response from passport", e)

    if ((dom.documentElement.getAttribute("status") == "error") or
        dom.documentElement.getElementsByTagName("error")):
        logger.error("User creation in passport failed with error: %s", xml)
        raise PassportException("User creation in passport failed with error", xml)
