# -*- coding: utf-8 -*-
_operations = {}


def register_operation(op_cls):

    op_id = op_cls.id
    if op_id in _operations:
        raise ValueError("Operation with id %r already exists" % op_id)

    _operations[op_cls.id] = op_cls

# force basic operations registration
import operations

def get_operation(id):
    '''
    Converts operation code in form "[+-]optype" to appropriate Operation
    instance.

    Examples:
    >>> get_operation("+inbox").__class__.__name__
    'InboxSubscribe'
    >>> get_operation("-imap").__class__.__name__
    'ImapUnsubscribe'
    '''
    return get_operation_class(id)()


def get_operation_class(id):
    klass = _operations.get(id)

    if not klass:
        raise ValueError("Could not find operation for id %r" % id)

    return klass
