# -*- coding: utf-8 -*-
'''
Module contains constants which defines available subscription types.
'''
from django.utils.translation import ugettext_lazy as _

IMAP = "imap"
EMAIL = "email"
INBOX = "inbox"
SEPARATE = "separate"

NONE = "none"
BOTH = "both"

basic_types = {
    IMAP: _("shared folder"),
    EMAIL: _("inbox (by email)"),
    INBOX: _("inbox (by account)"),
}

composite_types = dict(basic_types)
composite_types.update(
    {NONE: _("no subscription"),
     BOTH: _("inbox, shared folder")})
