# -*- coding: utf-8 -*-
import logging

from mlcore.subscribe import subscription_type
from mlcore.subscribe.type_change import get_transitional_operations

logger = logging.getLogger(__name__)


def unsubscribe_user(list, user, force_pending=False, omit_master=False):
    subscription = user.subscriptions.filter(list=list)
    if subscription.exists():
        return delete_user_subscription(subscription[0], force_pending=force_pending)
    else:
        return None


def delete_user_subscription(user_subscription, force_pending=False,
        omit_master=False, meddler=None):
    logger.info(u"Deleting user subscription %s", user_subscription)
    opList = get_transitional_operations(
                user_subscription.getType(),
                subscription_type.NONE)
    opList.setUser(user_subscription.user)
    opList.setList(user_subscription.list)
    opList.setContext({"revoke": True})

    if meddler is not None:
        opList.setContext({"meddler": meddler})

    return opList.perform(force_pending=force_pending,
            omit_master=omit_master) # todo: it should work
