import os

__interface_cache = {}


def load_backend_module(backend_name):
    '''
    Search for appropriate backend module, import and return it.
    Raises ImportError if backend name is invalid or backend is absent.
    '''
    backend_module = __import__("mlcore.subscribe.backends.%s.base" % (backend_name), fromlist=[''])
    return backend_module


def load_backend_interface(backend_name):
    if backend_name in __interface_cache:
        return __interface_cache[backend_name]
    else:
        backend_module = load_backend_module(backend_name)
        if hasattr(backend_module, 'backend_interface'):
            __interface_cache[backend_name] = backend_module.backend_interface
            return backend_module.backend_interface
        else:
            assert hasattr(backend_module, 'MaillistBackendInterface')
            backend_interface = backend_module.MaillistBackendInterface()
            __interface_cache[backend_name] = backend_interface
            return backend_interface


def find_available_backends():
    '''
    Listing all possible (built-in) backends.
    '''
    # based on django db backend discovering
    backend_dir = os.path.join(os.path.dirname(__file__), 'backends')
    try:
        available_backends = [f for f in os.listdir(backend_dir)
                if os.path.isdir(os.path.join(backend_dir, f))
                and not f.startswith('.')]
    except EnvironmentError:
        available_backends = []

    return available_backends
