# coding: utf-8

import socket
import cPickle
import logging
import time

from celery import Task, chain, chord
from django.conf import settings
from django.core.mail import send_mail

from django_intranet_stuff.models import Staff

# Импорты для celery worker'ов
import low_level
import base
import operations
import directory

import celery

logger = logging.getLogger('tasks')


@celery.task(default_retry_delay=3, acks_late=True)
def test_retry():
    import random
    try:
        if random.random() > 0.3:
            print "BANG\n"
            1/0
        else:
            print "DONE"
    except ZeroDivisionError, e:
        raise test_retry.retry(exc=e, max_retries=6)


@celery.task
def test_celery(message=None):
    """ Отсылает письмо settings.CELERY_TEST_EMAIL """
    hostname = socket.gethostname() or 'yandex.net'
    Staff.objects.count() # проверим базу
    logger.info(u"Celery работает! на %s", hostname)
    send_mail(u"Проверка работы celery",
              message or u"Celery отработала на %s" % hostname,
              'celery-test@%s' % hostname,
              [settings.CELERY_TEST_EMAIL])


from log import MLTask
from celery import task


@task(base=MLTask, ignore_result=True)
def test_logging(context):
    context['logger'].info(u"Работает тестовый таск")


def retry_operations(operationlogs, initiator='', force=False):
    """Презапускает операции из operationlogs если он слиманы, если
    force=True, перезапускает любую таску даже рутовую, в противном
    случае (force=False, случай по умолчанию) перезапускает только
    сломанные подтаски

    """
    for task in operationlogs:
        if not force:
            if task.parent is None and task.status != 'FAILURE':
                retry_operations(task.ifroot_descendants.filter(status='FAILURE'),
                                 initiator=initiator)
                continue

            if task.status != 'FAILURE':
                continue

        new_task = Task()
        new_task.name = task.name

        args = cPickle.loads(task.arguments.encode('ascii'))
        context = args['context']
        context['retry_parent'] = task.task_id
        context['initiator'] = initiator
        context['in_retry'] = True

        task.status = 'RETRIED'
        task.save()

        if force:
            context['comment'] = 'Restart. ' + context.get('comment', '')
            context['initiator'] = context.get('initiator') or task.initiator
            context['user'] = task.user
            context['list'] = task.list
            # помечаем устаревшим
            task.root.status = 'OBSOLETE'
            task.root.save()

        new_task.delay(context, *args['args'], **args['kwargs'])


@task
def add(x, y):
    print x + y


@task
def work(message):
    time.sleep(3)
    print message


@task
def finish(numbers):
    print numbers


@task
def test_chain():
    a = chain(add.si(0, 1), add.si(0, 2))
    b = chain(add.si(0, 3), add.si(0, 4))
    (a | b | add.si(0, 5)).delay()
    # chain(list(a.tasks) + list(b.tasks) + [add.si(0, 5)]).delay()


@task
def test_chord(n=5):
    ops = [(work.si(2 * i) | work.si(2 * i + 1)) for i in xrange(n)]
    chord(ops)(finish.si("finished"))
