# encoding: utf-8
from __future__ import unicode_literals

import logging
import json
from celery import task

from mlcore.tasks.log import MLTask
from mlcore.tasks.low_level import rnd_delay
from ya_directory import event_processor, EventNotSupported, ParseError, RetryProcess

logger = logging.getLogger(__name__)


@task(base=MLTask, max_retries=20)
def process_notification(event_data):
    try:
        event_processor.process(event_data)
    except EventNotSupported:
        logger.error('Event is not supported for message: %s', json.dumps(event_data))
    except ParseError as e:
        logger.error('Parse error: "%s" for message: %s', e.message, json.dumps(event_data))
    except RetryProcess as e:
        logger.error('Retry error for message: %s', json.dumps(event_data))
        raise process_notification.retry(exc=e, countdown=1+rnd_delay(10))
