# coding: utf-8

"""
Высокоуровневые операции, знаю обо всей грязной бизнес логике
проекта и не стесняются ее применять, основаны на предыдущих двух уровнях.
Отправляют письма тоже они.
Таски которые отправляют письма не нужно ретраить если они были успешно
завершены, их нужно вписать в tasks.DO_NOT_RETRY

"""

import logging

from celery import group, task
from django.conf import settings
from django.contrib.auth.models import User
from django.db import transaction
from mlcore.ml.models import ARCHIVING_TYPE, Subscribers
from mlcore.permissions.grant.user import is_user_owner
from mlcore.permissions.models import (GroupPermission, ListPermission,
                                       SubscriptionRequest, Type)
from mlcore.permissions.utils import can_read, can_write, is_external_staff
from mlcore.subscribe import subscription_type as sub_type
from mlcore.tasks import base, low_level
from mlcore.tasks.log import MLTask
from mlcore.tasks.notifications import AskPermission, PermissionRevoked
from mlcore.utils.getters import get_list, get_user


@task(base=MLTask)
def subscribe_user(context, user, maillist, type, meddler=None,
                   check_rights=True, autosubscription=None, send_notification=False, access_reason=None):
    """ Подписка """

    def dispatch_sub():
        if type == sub_type.INBOX or type == sub_type.SEPARATE:
            return base.subscribe_inbox(context, user, maillist, autosubscription, send_notification,
                                        type == sub_type.SEPARATE)
        elif type == sub_type.IMAP:
            return base.subscribe_imap(context, user, maillist, autosubscription, send_notification)
        elif type == sub_type.BOTH:
            return base.subscribe_both(context, user, maillist, autosubscription, send_notification)

    logger = subscribe_user.request.logger
    maillist = get_list(maillist)
    user = get_user(user)

    # не разрешаем подписываться сотрудникам без email'a
    if user.email == '':
        return base.finish_task.si(context,
                                   u"В рассылку %s нельзя подписаться %s сотруднику без email-a",
                                   logging.WARNING, maillist.name, user.username)

    if meddler is not None:
        meddler = get_user(meddler)
        # Если просящий подписку владелец то сразу подписывать, а не
        # спрашивать права на подписку
        is_owner = maillist.owner_set.filter(user=meddler).exists()
        if is_owner:
            check_rights = False
            logger.info(u"Не запрашиваем доступ, а сразу подписываем, "
                        u"так как %s владелец рассылки", meddler)

    # не разрешаем подписываться внешнему сотруднику,
    # если рассылка не-external_can_read
    if is_external_staff(user) and not maillist.external_staff_can_read:
        logger.info(u"Не подписываем. %s - внешний сотрудник", user.username)
        return base.finish_task.si(context,
                                   u"В рассылку %s нельзя подписаться %s-внешнему сотруднику",
                                   logging.WARNING, maillist.name, user.username)

    # проверка на is_open стоит позже external_can_read, 
    # потому что  https://st.yandex-team.ru/ML-1119#1403166120000
    if maillist.is_open:
        logger.info(u"Рассылка %s открытая, подписываем", maillist)
        return dispatch_sub().delay()

    # Проверяем права
    if can_read(user, maillist):
        logger.info(u"У %s есть доступ до %s", user, maillist)
        return (grant_permission.si(context, user, maillist) |
                dispatch_sub()).delay()

    if not check_rights:
        logger.info(u"У %s нет доступа до %s, выдаем.", user, maillist)
        (grant_permission.si(context, user, maillist) |
         dispatch_sub()).delay()
    else:
        logger.info(u"У %s нет доступа до %s, запрашиваем права",
                    user, maillist)
        if meddler is None:
            meddler = user
        ask_permission.delay(context, user, maillist, type, meddler, access_reason=access_reason)


@task(base=MLTask)
def subscribe_email(context, email, maillist):
    """ Подписка (по email) """
    base.subscribe_inbox(context, email, maillist).delay()


@task(base=MLTask)
def unsubscribe_email(context, email, maillist):
    """ Отписка (по email) """
    base.unsubscribe_inbox(context, email, maillist).delay()


@task(base=MLTask)
def unsubscribe(context, user, maillist, autosubscription=None):
    """ Отписка """
    (base.unsubscribe_both(context, user, maillist, autosubscription=autosubscription) |
     low_level.delete_permission.si(context, user, maillist)).delay()


@task(base=MLTask)
@transaction.atomic
def ask_permission(context, user, maillist, stype, meddler=None, perm_type='read', access_reason=None):
    """
    Запрос доступа

    stype - inbox/imap/None если None, то это запрос доступа без подписки
    meddler - тот кто запросил доступ
    perm_type - read/write
    access_reason - зачем пользователю нужно читать рассылку
    """

    assert stype in ('imap', 'inbox', 'both', 'separate', None)
    assert perm_type in ('read', 'write')

    logger = ask_permission.request.logger
    user = get_user(user)
    maillist = get_list(maillist)

    if is_external_staff(user) and not maillist.external_staff_can_read:
        logging.warning(u"Внешним сотрудником нельзя читать эту рассылку")
        return

    if perm_type == 'read':
        has_perm = can_read(user, maillist)
    else:
        has_perm = can_write(user, maillist)

    if has_perm:
        logger.warning(u"Уже и так есть доступ до рассылки")
        return

    perm, crt = ListPermission.objects.get_or_create(
        user=user, list=maillist, type_id=Type.objects.get(name=perm_type).id,
        defaults=dict(approved=False))

    if not crt:
        logger.warning(u"Доступ уже был выдан ранее")
        return

    if stype:
        req, crt = SubscriptionRequest.objects.get_or_create(
            permission=perm, defaults=dict(type=stype, meddler=meddler, access_reason=access_reason))

    notify_about_permission_request.delay(context, user, maillist, perm_type, access_reason, meddler)


@task(base=MLTask)
def notify_about_permission_request(context, user, maillist, perm_type='read', access_reason=None, meddler=None):
    """ Уведомление владельца о запросе доступа """
    logger = notify_about_permission_request.request.logger
    user = get_user(user)
    maillist = get_list(maillist)
    meddler = meddler and get_user(meddler)

    logger.info(u"Отсылаю письмо с запросом")
    mail = AskPermission(user, maillist, perm_type, access_reason, meddler)
    mail.send()


notify_about_permission_request.do_not_retry = True


@task(base=MLTask)
@transaction.atomic
def grant_permission(context, user, maillist, type_name='read'):
    """ Выдача доступа """
    logger = grant_permission.request.logger
    user = get_user(user)
    maillist = get_list(maillist)

    perm, crt = ListPermission.objects.get_or_create(
        user=user, list=maillist, type_id=Type.objects.get(name=type_name).id,
        defaults=dict(approved=True))

    if not crt:
        if perm.approved:
            logger.warning(u"Доступ уже был выдан")
        else:
            logger.info(u"Доступ уже был создан, только апрувим")
            perm.approved = True
            perm.save()


@task(base=MLTask)
def change_subscription_type(context, user, maillist, new_type, meddler=None):
    """ Смена типа подписки """
    logger = change_subscription_type.request.logger
    user = get_user(user)
    maillist = get_list(maillist)

    # Если тип none то отписать
    if new_type == sub_type.NONE:
        logger.info("Отписываю с отзывом прав")
        unsubscribe.delay(context, user, maillist)
        return

    # Если пользователь не подписан, то подписать
    subscription = user.subscriptions.filter(list=maillist)
    if not subscription:
        logger.info(u"Подписываем ранее неподписанного пользователя %s", user)
        return subscribe_user.delay(context, user, maillist, new_type,
                                    meddler=meddler, send_notification=True)

    # Если пользователь хочет подписаться и в imap и в inbox
    if new_type == sub_type.BOTH:
        logger.info(u"Подписываем пользователя %s и в imap и в inbox", user)
        subscribe_user.delay(context, user, maillist, new_type, meddler=meddler)

    # Если пользователь был подписан на одно а хочет подписаться на другое
    else:
        before, after = subscription[0].stype, new_type
        if before == after:
            logger.warning(u"Пользователь %s уже подписан в %s", user, before)
            return
        else:
            logger.info(u"Меняем у %s тип подписки с %s на %s ",
                        user, before, after)

        # Стараемся не отписывать лишний раз пользователя от общей папки
        if after == sub_type.IMAP and before == sub_type.BOTH:
            (base.unsubscribe_inbox(context, user, maillist) |
             subscribe_user.si(context, user, maillist, new_type,
                               meddler=meddler)).delay()
        elif after == sub_type.BOTH and before == sub_type.IMAP:
            subscribe_user.delay(context, user, maillist, new_type,
                                 meddler=meddler)
        else:
            (base.unsubscribe_both(context, user, maillist) |
             subscribe_user.si(context, user, maillist, new_type,
                               meddler=meddler)).delay()


@task(base=MLTask)
def create_maillist(context, data, user=None, use_cmail=False):
    """ Создание рассылки """
    if user:
        user = get_user(user)
    base.create_maillist(context, data, user, use_cmail=use_cmail).delay()


@task(base=MLTask)
def resubscribe(context, user, maillist):
    """ Переподписка """
    user = get_user(user)
    maillist = get_list(maillist)
    logger = resubscribe.request.logger
    try:
        sb = Subscribers.objects.get(user=user, list=maillist)
    except Subscribers.DoesNotExist:
        logger.warning(u"Пользователь %s небыл подписан на %s. Выхожу.",
                       user, maillist)
        return

    (base.unsubscribe_both(context, user, maillist) |
     subscribe_user.si(context, user, maillist, sb.stype,
                       check_rights=False)).delay()


@task(base=MLTask)
def one_notify_unsubscribed(context, user, maillists, reason='',
                            notification=PermissionRevoked, **extra_context):
    """
    Уведомить об отписке.
    Одному пользователю посылается одно сообщение со списком рассылок, к которым у него больше нет доступа
    """
    user = get_user(user)
    ctx = {'lists': [get_list(maillist) for maillist in maillists], 'reason': reason}
    ctx.update(extra_context)

    email = notification(ctx)
    email.send([user.email], sender=settings.SERVICE_EMAIL)


one_notify_unsubscribed.do_not_retry = True


@task(base=MLTask)
def notify_unsubscribed(context, user, maillist, reason='',
                        notification=PermissionRevoked, **extra_context):
    """ Уведомить об отписке """
    user = get_user(user)
    ctx = {'list': get_list(maillist), 'reason': reason}
    ctx.update(extra_context)

    email = notification(ctx)
    email.send([user.email], sender=settings.SERVICE_EMAIL)


notify_unsubscribed.do_not_retry = True


@task(base=MLTask)
def unsubscribe_and_notify(context, user, maillist, reason='',
                           notification=PermissionRevoked, **extra_context):
    """ Отписка и уведомление """
    (base.unsubscribe_both(context, user, maillist) |
     low_level.delete_permission.si(context, user, maillist) |
     notify_unsubscribed.si(context, user, maillist, reason,
                            notification, **extra_context)).delay()


@task(base=MLTask)
def delete_group_permission(context, group, maillist):
    """ Удаление группового доступа """
    logger = delete_group_permission.request.logger
    try:
        perm = GroupPermission.objects.get(group=group, list=maillist)
    except GroupPermission.DoesNotExist:
        logger.exception(u"Нет такой записи в базе. Некого отписывать.")
        return
    perm.delete()


@task(base=MLTask)
def unsubscribe_group(context, grp, maillist, reason):
    """ Отписка удаленной группы """
    maillist = get_list(maillist)

    to_unsubscribe = []
    for user in grp.members.all():
        to_unsubscribe.append(
            (base.unsubscribe_both(context, user, maillist) |
             low_level.delete_permission.si(context, user, maillist) |
             notify_unsubscribed.si(context, user, maillist, reason=reason)))

    return group(to_unsubscribe).delay()


@task(base=MLTask, max_retries=42)
@transaction.atomic
def change_maillist_open_property(context, maillist, to_close, to_open):
    """ Изменить свойства cmail-рассылки """
    maillist = get_list(maillist)
    logger = change_maillist_open_property.request.logger

    subscribers = User.objects.filter(subscriptions__list=maillist)

    """
    Это было до отрыва cmail, теперь кажется не нужно.
    if to_close:
        # Переподпишем всех чтобы почтовые системы (cmail) знали что
        # нужно продолжать слать письма
        logger.info(u"Выдаем доступ всем ранее подписанным пользователям.")
        for user in subscribers:
            resubscribe.delay(context, user, maillist)
    """

    if to_open:
        logger.info(u"Удаляем персональные права доступа до рассылки")
        ListPermission.objects.filter(
            user__in=subscribers, list=maillist, type__name='read').delete()


@task(base=MLTask, max_retries=42)
@transaction.atomic
def change_shared_flags(context, maillist, user, is_shared_flags):
    """ Общие флажки """
    maillist = get_list(maillist)
    logger = change_shared_flags.request.logger

    if not is_user_owner(maillist, user):
        return

    low_level.set_shared_flags_ymail.delay(context, maillist, is_shared_flags)
    logger.info(u"Изменили общие флажки")


@task(base=MLTask)
@transaction.atomic
def change_parent(context, maillist, user, parent=None):
    """
    Изменение родителя (перенос общих папок).
    """
    # Если parent==None, то удаляем родителя (переносим шареную папку в корень Yandex)
    # edit_list.py НЕ может вызвать эту функцию с parent==None.
    # Только views.py может вызывать эту функцию с parent==None (при нажатии на ссылку
    # "удалить родителя" в интерфейсе ML)

    logger = change_parent.request.logger
    maillist = get_list(maillist)
    user = get_user(user)
    if not is_user_owner(maillist, user):
        logger.info(u"Пользователю %s нельзя менять это свойство (не owner для %s)", user, maillist)
        return

    parent_maillist = get_list(parent) if parent else None
    if parent_maillist and not is_user_owner(parent_maillist, user):
        logger.info(u"Пользователю %s нельзя менять это свойство (не owner для %s-родителя)", user, parent_maillist)
        return

    low_level.move_list_ymail.delay(context, maillist, parent_maillist)
    maillist.parent = parent_maillist
    maillist.save()
    logger.info(u"Изменили родителя для %s", maillist)


@task(base=MLTask)
@transaction.atomic
def change_archiving_options(context, maillist, user, is_archive, before_clean, max_size,
                             archiving_type=ARCHIVING_TYPE.CL):
    """ Архивация писем (удаление через N дней, максимальное количество писем, которое нужно оставлять в папке) """

    logger = change_archiving_options.request.logger
    maillist = get_list(maillist)
    user = get_user(user)
    if not is_user_owner(maillist, user):
        logger.info(u"Пользователю %s нельзя менять это свойство (не owner)", user)
        return

    low_level.change_ymail_archiving_options.delay(context, maillist, is_archive, before_clean, max_size,
                                                   archiving_type)
    maillist.is_archive = is_archive
    maillist.before_clean = before_clean
    maillist.max_size = max_size
    maillist.archiving_type = archiving_type
    maillist.save()
    logger.info(u"Изменили параметры удаления писем")
