import types


def memoizible_property(getter):

    key = '_cache_prop_' + getter.__name__

    def getter_wrapper(self, *args, **kwargs):

        if not hasattr(self, key):
            result = getter(self, *args, **kwargs)
            if isinstance(result, types.GeneratorType):
                result = list(result)
            setattr(self, key, result)
            return result
        return getattr(self, key)

    return property(getter_wrapper)
