# coding: utf-8

from django.db.models import Q
from django.contrib.auth.models import User

from django_intranet_stuff.models import Staff
from mlcore.ml.models import MailList, SuidLookup, Autosubscription
from mlcore.utils.blackbox_util import get_suid as g_suid, get_uid as g_uid, get_userinfo as g_user
from mlcore.subscribe.backends.yandex_team.models import YandexTeamBackendContext


def get_user(user):
    if isinstance(user, basestring):
        return User.objects.get(Q(username=user) | Q(email=user) | Q(staff__uid=user))
    elif isinstance(user, User):
        return user
    elif isinstance(user, Staff):
        return user.user
    elif isinstance(user, int):
        return User.objects.get(staff__uid=user)
    else:
        raise TypeError("Unknow type of user - %s" % type(user))


def get_staff(user):
    if isinstance(user, basestring):
        return Staff.objects.get(Q(login=user) | Q(work_email=user))
    elif isinstance(user, User):
        return user.staff
    elif isinstance(user, Staff):
        return user
    else:
        raise TypeError("Unknow type of user - %s" % type(user))


def get_list(maillist):
    if isinstance(maillist, (int, long)):
        return MailList.objects.get(Q(fsuid=maillist) | Q(fid=maillist))
    elif isinstance(maillist, MailList):
        return maillist
    elif isinstance(maillist, basestring):
        try:
            return MailList.objects.get(name=maillist)
        except MailList.DoesNotExist:
            return YandexTeamBackendContext.objects.get(
                passport_name=maillist).maillist
    else:
        raise TypeError("Unknow type of maillist - %s" % type(maillist))


def get_suid_by_login(login):
    """Возвращает суид по логину.
    Лучше использовать более обущю функцию get_suid

    """
    try:
        return SuidLookup.objects.get(login=login).suid
    except SuidLookup.DoesNotExist:
        suid = g_suid(login)
        if not suid:
            return

        SuidLookup.objects.create(suid=suid, login=login)
        return int(suid)


def get_suid(user):
    """ Возвращает suid пользователя или рассылки
    user - suid пользователя, login, Staff, User или imap-name рассылки
    """
    if isinstance(user, (int, long)):
        return user
    elif isinstance(user, basestring):
        return get_suid_by_login(user)
    elif isinstance(user, User):
        return get_suid_by_login(user.username)
    elif isinstance(user, Staff):
        return get_suid_by_login(user.login)
    elif isinstance(user, MailList):
        return user.fsuid
    else:
        raise TypeError("Unknow type of user - %s" % type(user))


def get_list_suid(maillist):
    """ Возвращает суид подписки по fid, name, imap-name, MailList """
    maillist = get_list(maillist)
    if maillist.fsuid is not None:
        return maillist.fsuid
    return get_suid(YandexTeamBackendContext.objects.get(
        maillist=maillist).passport_name)


def get_list_uid(maillist):
    maillist = get_list(maillist)
    backend_record = YandexTeamBackendContext.objects.get(maillist=maillist)
    if backend_record.uid:
        return backend_record.uid
    uid = g_uid(backend_record.passport_name)
    if uid:
        backend_record.uid = uid
        backend_record.save(update_fields=['uid'])
    return uid

def get_list_by_uid(uid):
    if isinstance(uid, int):
        try:
            backend_record = YandexTeamBackendContext.objects.get(uid=uid)
        except YandexTeamBackendContext.DoesNotExist:
            user = g_user(uid)
            backend_record = YandexTeamBackendContext.objects.get(passport_name=user.get('passport_name', None))
        return backend_record.maillist

def get_autosubscription(autosub):
    if isinstance(autosub, Autosubscription):
        return autosub
    elif isinstance(autosub, (int, long)):
        return Autosubscription.objects.get(pk=autosub)
    elif isinstance(autosub, (tuple, list)):
        assert len(autosub) == 3
        name, group_id, stype = autosub
        return Autosubscription.objects.get(maillist__name=name,
                                            group_id=group_id, stype=stype)


def get_user_uid(user):
    try:
        return user.staff.uid
    except Staff.DoesNotExist:
        return g_uid(user.username)
