import logging

from cachetools import TTLCache
from django.conf import settings
from utvm import TVM


TVM2_CONFIG = TVM(settings.TVM2_CLIENT_ID, settings.TVM2_SECRET, use_v1=False)


_ticket_cache = TTLCache(settings.TVM2_TICKET_CACHE_SIZE, settings.TVM2_TICKET_CACHE_TTL)
_ticket_getter = TVM2_CONFIG.ticket_getter()


def get_tvm_2_header(destination_id):
    """Get tvm 2 ticket
    Returns: dictionary with ticket header, e. g.
        >>>{
        >>>    'x-ya-user-ticket': '...',
        >>>}
    """

    if destination_id not in _ticket_cache:
        try:
            headers = _ticket_getter.get_service_ticket_headers(destination_id)[str(destination_id)]
        except Exception:
            logging.exception('Failed to get TVM 2 ticket for destination %s' % destination_id)
            headers = {}

        _ticket_cache[destination_id] = headers

    return _ticket_cache[destination_id]
