# encoding: utf-8

"""
Клиент для mulcagate
~~~~~~~~~~~~~~~~~~~~

Как использовать:

    import mulcagate
    
    r = mulcagate.put(suid='0123456789', body='Example BLOB', raw=True)
    print("Object stored with mid: {}".format(r.mid))
    
    r = mulcagate.get(mid=r.mid, raw=True)
    print("Got data: {}".format(r.content))
    
    r = mulcagate.delete(mid=r.mid)
    print("Object with mid={} deleted. Mulcagate response was: {}".format(r.mid, r.content))
    

Больше примеров тут: https://github.yandex-team.ru/lavrinenko/python-mulcagate

"""

__title__ = 'mulcagate'
from .version import __version__
__author__ = 'Sergey Lavrinenko'
__copyright__ = 'Copyright 2013 Yandex'

from .mulcagate import MulcaGate
from .helpers import get, put, del_, delete, message
