# encoding: utf-8
from __future__ import print_function, unicode_literals

# Known mulca urls
# See also: http://wiki.yandex-team.ru/Users/vkap/mulcagate

ENV = {
         'development': { 'url': 'http://storagetest.mail.yandex.net:10010/gate', 'timeout': 25.0 },
         'production':  { 'url': 'http://storage.mail.yandex.net:10010/gate', 'timeout': 10.0 }
       }

DEFAULT_HTTP_TIMEOUT = 3

class Environment:

    """
    Environment for mulcagate object.
    """

    def __init__(self, url, timeout=None, **kw):

        env = ENV.get(url)

        if env:
            self.url = env['url']
            self.timeout = env.get('timeout')
        else:
            self.url = url

        if timeout is not None:
            self.timeout = timeout

        if not self.timeout:
            self.timeout = DEFAULT_HTTP_TIMEOUT

        for (k, v) in kw.items():
            setattr(self, k, v)


def from_url(*args, **kw):
    return Environment(*args, **kw)


def from_yenv():

    """
    Returns envitronment based on yenv settings.

    yenv:https://github.yandex-team.ru/common-python/yenv
    """

    import yenv

    # Мапинг урлов для различных окружений
    yenv_dict = {
        'other': {
            'development': ENV['development'],
            'production': ENV['production'],
            'testing': ENV['development']
        }
    }
    
    yenv_dict['localhost'] = yenv_dict['other']
    yenv_dict['intranet'] = yenv_dict['other']

    env = yenv.choose_key_by_type(yenv.choose_key_by_name(yenv_dict, fallback=False), fallback=False)

    return Environment(**env)

