# encoding: utf-8

from .mulcagate import MulcaGate
from .models import Message
from functools import wraps
import threading

def get_mulca():
    data = threading.local()
    _mulca = getattr(data, '_mulca', None)
    if _mulca is None:
        _mulca = data._mulca = MulcaGate.from_yenv()
    return _mulca

def _caller(method):
    def wrapper(*args, **kw): 
        return getattr(get_mulca(), method)(*args, **kw)
    return wrapper

def get_message(**kw):
    return Message(mulcagate=get_mulca(), **kw)


get  = _caller('get')
put  = _caller('put')
delete = del_ = _caller('del_')

message = get_message
