# encoding: utf-8
from __future__ import print_function, unicode_literals

import requests
from copy import deepcopy
from .response import Response
from . import environment

# See also: http://wiki.yandex-team.ru/Users/vkap/mulcagate

class BaseMulcaGate(object):

    def __init__(self, env):
        self.env = env
        self.http_client = requests.Session()
        self.default_http_client_params = { 'allow_redirects': False }

    def http_call(self, http_method, api_method, **kw):
        _kw = deepcopy(self.default_http_client_params)
        _kw.update(kw)
        url = self.env.url + api_method
        http_response = self.http_client.request(method=http_method,
                                        url = url,
                                        timeout = self.env.timeout,
                                        **_kw)

        r = Response.from_http_response(http_response, url=url)
        return r

def _parse_stid(st_id):
    stid_parts = st_id.split('.')
    stid_parts[0] = stid_parts[0].split(':')[-1]
    return '.'.join(stid_parts)

class MulcaGate(BaseMulcaGate):

    @classmethod
    def from_yenv(cls):
        return cls(env=environment.from_yenv())

    @classmethod
    def from_url(cls, url, **kw):
        env = environment.from_url(url=url, **kw)
        return cls(env=env)

    def get(self, st_id, **kw):
        # Parameters: gettype offset length part msg raw
        st_id = _parse_stid(st_id)
        #print __name__, "get st_id=", st_id
        r = self.http_call('GET', '/get/%s' % st_id, params=kw)
        r.parse(method='get', mid=st_id)
        return r

    def put(self, suid, body, **kw):
        # Parameters: comp msg/raw direct
        for k in ['raw', 'msg']:
            # raw and msg parameters is flags
            if (k in kw) and (not kw[k]):
                del kw[k]
        if hasattr(body, 'read'):
            body = body.read()
        r = self.http_call('POST', '/put/%s' % suid, params=kw, data=body)
        r.parse(method='put', suid=suid)
        return r

    def del_(self, st_id):
        st_id = _parse_stid(st_id)
        r = self.http_call('GET', '/del/%s' % st_id)
        r.parse(method='del', st_id=st_id)
        return r

    delete = del_

    def status(self):
        r = self.http_call('GET', '/status')
        r.parse(method='status')
        return r
