# encoding: utf-8

from .exceptions import ResponseStatusError

class Response(object):

    """
    Класс для упаковки ответа mulcagate
    """

    def __init__(self, url=None, suid=None, st_id=None, method=None, http_response=None):
        self.url = url
        self.st_id = st_id
        self.suid = suid
        self.method = method
        self.http_response = http_response

    def raise_on_error(self):
        if self.http_response.status_code!=200:
            raise ResponseStatusError(msg='Invalid mulcagate status code', response=self.http_response)
            # TODO: add status_code and response content to exception object 
    
    @property
    def content(self):
        if self.http_response:
            return self.http_response.content

    @property
    def text(self):
        if self.http_response:
            return self.http_response.text

    @property
    def status_code(self):
        if self.http_response:
            return self.http_response.status_code
        
    def parse(self, method, **kw):

        self.raise_on_error()
        
        for (k, v) in kw.items():
            setattr(self, k, v)

        parse_func = getattr(self, '_parse_'+method, None)
        if parse_func:
            parse_func()
        else:
            raise RuntimeError("Don't know how to parse '{0}' reponse".format(method))

    def _parse_put(self):
        body = self.http_response.content
        self.st_id = body.strip()

    def _parse_get(self):
        pass

    def _parse_status(self):
        self.status = self.content        

    def _parse_del(self):
        self.status = self.content  
                        
    @classmethod
    def from_http_response(cls, http_response, **kw):
        r = cls(**kw)
        r.http_response = http_response
        return r


"""

ymailapi.operations.message.response.Message:


    def is_valid(self):
        r = self._message is not None and not len(self._message.xpath("//error"))

        if not r:
            if self._message is None:
                logger.warning(u'Message is None')
            else:
                logger.warning(u'Message is not valid: %s', lxml.etree.tostring(self._message))

        return r

    # Identification info

    @property
    def fid(self):
        return self._message.find("header/fid").text

    @property
    def st_id(self):
        return self._message.find("identification/st_id").text

    @property
    def mid(self):
        return self._message.find("identification/mesid").text

    # Header info

    @property
    def date_header(self):
        return self._to_datetime(self._message.find("header/hdr_date").text)

    @property
    def date_received(self):
        return self._to_datetime(self.date_received_str)

    @property
    def date_received_str(self):
        return self._message.find("header/recv_date").text

    @property
    def cc(self):
        return map(self._elements_to_dict,
                self._message.findall("message_header_mulca/cc/item"))

    @property
    def from_header(self):
        return self._elements_to_dict(self._message.findall("header/hdr_from/item/*"))

    @property
    def from_email(self):
        return self._message.find("header/hdr_from/item/email").text

    @property
    def reply_to_email(self):
        return self._message.find("header/reply_to/item/email").text

    @property
    def to(self):
        return map(self._elements_to_dict,
                self._message.findall("header/hdr_to/item"))

    @property
    def reply_to_all(self):
        return map(self._elements_to_dict,
                self._message.findall("header/reply_to_all/item"))

    @property
    def reply_to_all_emails(self):
        return [e.text for e in self._message.findall("header/reply_to_all/item/email")]

    @property
    def to_emails(self):
        return [e.text for e in self._message.findall("header/hdr_to/item/email")]

    @property
    def in_reply_to(self):
        return self._message.find("message_header_mulca/in-reply-to").text

    @property
    def references(self):
        return self._message.find("message_header_mulca/references").text.split(' ')

    @property
    def message_id(self):
        return self._message.find("message_header_mulca/message-id").text

    @property
    def subject_prefix(self):
        prefix_element = self._message.find("header/hdr_subject/prefix")
        return prefix_element.text if prefix_element is not None else ''

    @property
    def subject_text(self):
        return self._message.find("header/hdr_subject/text").text

    @property
    def subject(self):
        return self.subject_prefix + self.subject_text

    @property
    def firstline(self):
        return self._message.find("header/firstline").text

    # Message main info/content
    @property
    def first_part(self):
        return MessagePart(self._message.find("body/part"), parent=self)

    def get_parts(self):
        return list(self.iter_parts())

    def iter_parts(self):
        return (MessagePart(p, parent=self) for p in self._message.findall("body/part"))

    def iter_attachments(self):
        return (p for p in self.iter_parts() if p.is_attachment)

    def get_attachments(self):
        return [
            MessagePart(p, parent=self)
            for p in
                self._message.xpath(
                    "/yamail/message/body/part[disposition_value='attachment']")]

    def get_mentioned_emails(self):
        # TODO: make more robust
        return self._message.xpath("//email/text()")

    def map_recipients(self, email_mapping):
        for email in set(self.get_mentioned_emails()):
            if email in email_mapping:
                yield email_mapping[email]


class MessagePart(object):

    def __init__(self, xml_node, parent):
        self._node = xml_node
        self._link = None
        self._message = parent
        super(MessagePart, self).__init__()

    def __str__(self):
        return self.hid, self.mimetype

    @property
    def content_id(self):
        return self._node.findtext("content_id")

    @property
    def hid(self):
        return self._node.find("hid").text

    @property
    def length(self):
        return self._node.find("length").text

    @property
    def type(self):
        return self._node.find("type").text

    @property
    def subtype(self):
        return self._node.find("subtype").text

    @property
    def mimetype(self):
        return '/'.join((self.type, self.subtype))

    @property
    def disposition_filename(self):
        return self._node.find("disposition_filename").text

    @property
    def disposition_value(self):
        return self._node.find("disposition_value").text

    @property
    def content(self):
        element = self._node.find("content")
        if self.subtype == 'plain':
            return element.text
        elif self.subtype == 'html':
            return self._build_html_content(element)
        elif self.subtype =='calendar':
            return self._build_calendar_content(element)
        else:
            return self._build_xml_content(element)

    def _build_calendar_content(self, element):
        vcal = element.find('vcalendar')
        if vcal is not None:
            description_node = vcal.find("vevent/description")
            if description_node is not None:
                return description_node.text
        return self._build_xml_content(element)

    def _build_xml_content(self, element):
        return lxml.etree.tounicode(element, method='xml')

    def _build_html_content(self, element):
        return lxml.etree.tounicode(element, method='html')

    @property
    def is_attachment(self):
        return self.disposition_value == 'attachment'

    def get_download_link(self, force=False):
        if self._link is None or force:
            op_cls = get_operation_class('message_part_link', base_cls=MailApiRequest)
            op = op_cls(session_id=self.parent.session_id)
            self._link = op.perform(
                    hid=self.hid,
                    mid=self._message.mid,
                    name=self.disposition_filename or "attachment")
        return self._link
"""