# -*- coding: utf-8 -*-

import os

from django.conf.urls import patterns, url, include
from django.views.generic.base import RedirectView
from django.conf import settings
from django.contrib.staticfiles.urls import staticfiles_urlpatterns


from admin import admin_site

js_info_dict = {
    'packages': (),
}

urlpatterns = []

if settings.DEBUG:
    urlpatterns += patterns('',
        (r'^media/(?P<path>.*)$', 'django.views.static.serve', {'document_root': settings.MEDIA_ROOT}),
        (r'^js/(?P<path>.*)$', 'django.views.static.serve', {'document_root': os.path.join(settings.MEDIA_ROOT, 'js/')}),
        (r'^css/(?P<path>.*)$', 'django.views.static.serve', {'document_root': os.path.join(settings.MEDIA_ROOT, 'css/')}),
        (r'^i/(?P<path>.*)$', 'django.views.static.serve', {'document_root': os.path.join(settings.MEDIA_ROOT, 'i/')}),
        (r'^block/(?P<path>.*)$', 'django.views.static.serve', {'document_root': os.path.join(settings.MEDIA_ROOT, 'block/')}),
        (r'^lego/(?P<path>.*)$', 'django.views.static.serve', {'document_root': os.path.join(settings.MEDIA_ROOT, 'lego/')}),
        #(r'^admin/media/(?P<path>.*)$', 'django.views.static.serve', {'document_root': "/usr/share/python-support/python-django-snapshot/django/contrib/admin/media"}),
    )

urlpatterns += patterns('',
    (r'^', include('mlcore.ml.urls')),
    (r'^', include('mlcore.mailarchive.urls', namespace='mailarchive')),
    (r'^stat/', include('mlcore.stats.urls')),
    (r'^api/', include('mlcore.mlapi.urls', namespace='mlapi')),
    (r'^apiv1/', include('mlcore.mlapi.urls', namespace='apiv1')), # Копия ручек api для таска ML-1325
    (r'^apiv2/', include('mlcore.apiv2.urls', namespace='apiv2')),
    (r'^apiv3/', include('mlcore.apiv3.urls', namespace='apiv3')),
    (r'sms_filter/', include('mlcore.sms_filter.urls')),

    (r'^admin/', include(admin_site.urls)),

    (r'^jsi18n/$', 'django.views.i18n.javascript_catalog', js_info_dict),
)


urlpatterns += patterns('',
    (r'^archive/(?P<tail>.*)$', RedirectView.as_view(url='/%(tail)s')),
    (r'^letter/(?P<letter>.+).json$',
        RedirectView.as_view(url='/api/letter/%(letter)s.json')),
)

# ML-65
urlpatterns += patterns('',
    (r'^(?P<list>[0-9A-Za-z@\._\-]+)/$', RedirectView.as_view(url='/lists/%(list)s')),
)
