# encoding: utf-8


class EventNotSupported(Exception):
    pass


class ParseError(Exception):
    pass


class DirectoryAPIError(Exception):
    code = None

    def __init__(self, message='', response=None):
        super(DirectoryAPIError, self).__init__(message)
        self.response = response

    @property
    def response_data(self):
        # иметь доступ к данным из ошибки иногда полезно
        if self.response is not None:
            return self.response.json()

    @property
    def response_status_code(self):
        if self.response is not None:
            return self.response.status_code

    @property
    def response_content(self):
        if self.response is not None:
            return self.response.content


class DirectoryRepeatResponse(DirectoryAPIError):
    pass


class DirectoryNotFound(DirectoryAPIError):
    pass


class DirectoryForbidden(DirectoryAPIError):
    pass


class Unprocessable(DirectoryAPIError):
    pass


class DirectoryResponseError(DirectoryAPIError):
    pass


class RetryProcess(Exception):
    pass


class DirectoryAlreadyExistsError(DirectoryAPIError):
    pass
