#pragma once


#include "context.h"
#include "logger.h"
#include "types.h"

#include <macs/envelope_factory.h>
#include <macs/mime_part_factory.h>
#include <macs/threads_meta.h>

#include <util/generic/maybe.h>
#include <yplatform/task_context.h>

#include <string>
#include <vector>

namespace NMdb {


macs::Envelope BuildEnvelope(
    const TMessageBase& message,
    const std::string& fid,
    const std::vector<TLid>& lids,
    const std::optional<macs::Tab::Type>& tab,
    const THeaders& headers,
    const std::vector<TAttachment>& attachments,
    TContextPtr taskCtx);

macs::MimeParts BuildMimeParts(const std::vector<TMimePart>& parts);

macs::ThreadMeta BuildThreadMeta(const TThreadInfo& info);

} // namespace NMdb
