#pragma once

#include <yplatform/task_context.h>

#include <boost/shared_ptr.hpp>

#include <string>
#include <tuple>

namespace NMdb {

class TMdbContext : public yplatform::task_context {
public:
    TMdbContext(const std::string& uniqId, const yplatform::log::source& logger)
        : yplatform::task_context(uniqId)
    {
        this->logger() = logger;
        std::tie(ConnectionId, EnvelopeId) = SplitSessionId(uniqId);
    }

    const std::string& connectionId() const {
        return ConnectionId;
    }

    const std::string& envelopeId() const {
        return EnvelopeId;
    }

    const std::string& sessionId() const {
        return uniq_id();
    }

private:
    std::tuple<std::string, std::string> SplitSessionId(const std::string& sessionId) {
        const auto separator{sessionId.find('-')};
        if (separator == std::string::npos) {
            return std::make_tuple(sessionId, std::string{});
        }

        return std::make_tuple(sessionId.substr(0, separator), sessionId.substr(separator + 1));
    }

    std::string ConnectionId;
    std::string EnvelopeId;
};

using TContext = TMdbContext;
using TContextPtr = boost::shared_ptr<TMdbContext>;

} // namespace NMdb
