#include "errors.h"

#include <vector>
#include <string>
#include <sstream>

namespace NMdb {

std::string ErrorMessage(const mail_errors::error_code& err) {
    std::stringstream str;
    str << "{ message: " << err.base().message()
        << ", description: " << err.what() << " }";
    return str.str();
}

struct TErrorCategory: boost::system::error_category {
    const char* name() const noexcept override {
        return "NMdb::TErrorCategory";
    }

    std::string message(int v) const override {
        static constexpr std::initializer_list<const char*> messages = {
            "ok",
            "store to db error",
            "no such folder",
            "no such folder permanent error",
            "operation exception"
        };
        static_assert(messages.size() == static_cast<int>(EError::COUNT), "error codes count doesn't correspond with messages count");
        static const std::vector<std::string> errorMessages(messages.begin(), messages.end());
        return errorMessages[v];
    }
};

const boost::system::error_category& GetErrorCategory() {
    static TErrorCategory instance;
    return instance;
}

} // namespace NMdb
