#pragma once

#include <mail_errors/error_code.h>

#include <boost/system/error_code.hpp>

namespace NMdb {

std::string ErrorMessage(const mail_errors::error_code&);

enum class EError {
    Ok = 0,
    StoreToDbError,
    NoSuchFolderTemp,
    NoSuchFolderPerm,
    OperationException,

    COUNT
};

} // namespace NMdb

namespace boost {
namespace system {

template <>
struct is_error_code_enum<NMdb::EError> {
    static const bool value = true;
};

} // namespace system
} // namespace boost

namespace NMdb {

const boost::system::error_category& GetErrorCategory();

inline boost::system::error_code make_error_code(EError e) {
    return boost::system::error_code(static_cast<int>(e), GetErrorCategory());
}

} // namespace NMdb
