#pragma once

#include <logdog/format/tskv.h>
#include <logdog/backend/yplatform_log.h>
#include <logdog/attributes/mail_attributes.h>

namespace log {

LOGDOG_DEFINE_ATTRIBUTE(std::string, method)
LOGDOG_DEFINE_ATTRIBUTE(std::string, uniq_id)
LOGDOG_DEFINE_ATTRIBUTE(std::string, connection_id)
LOGDOG_DEFINE_ATTRIBUTE(std::string, envelope_id)
LOGDOG_DEFINE_ATTRIBUTE(std::string, uid)
LOGDOG_DEFINE_ATTRIBUTE(std::string, mid)
LOGDOG_DEFINE_ATTRIBUTE(std::string, imap_id)
LOGDOG_DEFINE_ATTRIBUTE(bool, duplicate)
LOGDOG_DEFINE_ATTRIBUTE(std::string, error_type)

constexpr static auto MDBSAVE_FORMATTER = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-mdbsave-tskv-log"));

} // namespace log

inline auto MakeLogger(const yplatform::log::source& logger) {
    return logdog::make_log(
        log::MDBSAVE_FORMATTER,
        logger
    );
}

#define MDBSAVE_LOG_DEBUG(ctx, ...) \
    LOGDOG_(MakeLogger(ctx->logger()), debug, \
        log::uniq_id = ctx->uniq_id(), \
        log::connection_id = ctx->connectionId(), \
        log::envelope_id = ctx->envelopeId(), \
        __VA_ARGS__ \
    );
#define MDBSAVE_LOG_NOTICE(ctx, ...) \
    LOGDOG_(MakeLogger(ctx->logger()), notice, \
        log::uniq_id = ctx->uniq_id(), \
        log::connection_id = ctx->connectionId(), \
        log::envelope_id = ctx->envelopeId(), \
        __VA_ARGS__ \
    );
#define MDBSAVE_LOG_WARN(ctx, ...) \
    LOGDOG_(MakeLogger(ctx->logger()), warning, \
        log::uniq_id = ctx->uniq_id(), \
        log::connection_id = ctx->connectionId(), \
        log::envelope_id = ctx->envelopeId(), \
        __VA_ARGS__ \
    );
#define MDBSAVE_LOG_ERROR(ctx, ...) \
    LOGDOG_(MakeLogger(ctx->logger()), error, \
        log::uniq_id = ctx->uniq_id(), \
        log::connection_id = ctx->connectionId(), \
        log::envelope_id = ctx->envelopeId(), \
        __VA_ARGS__ \
    );
